; PRisme Monitor
; Version 0.99
; (c) 2005 by Freddy


; === basic includes ===

.include 	"m8535def.inc"		; include AVR port/bit definitions
.include 	"definitions.asm"	; include register/constant definitions
.include 	"macros.asm"		; include macro definitions


; === interrupt vector table ===

.org	0				; reset vector
	rjmp	reset
.org	URXCaddr			; USART receive complete
	rjmp	UART_rxc
.org	UDREaddr			; USART data registry empty
	rjmp	UART_dre
.org	0x15				; end of vector table


; === interrupt service routine ===

	; PUT YOUR INTERRUPT SERVICE ROUTINES HERE


; === initialisation ===

reset:	LDSP	RAMEND			; Load Stack Pointer (SP)
	
	OUTI	DDRA,0x00		; configure PortA: all input
	OUTI	DDRB,0x04		; configure PortB: LED output, rest input
	OUTI	DDRC,0x00		; configure PortC: all input
	OUTI	DDRD,0x00		; configure PortD: all input
	
	rcall	monitor_init		; initialize Monitor (also UART and Interrupts)


	; PUT EXTRA INITIALISATION HERE


	sbi	PORTB,2			; clear LED

	rjmp	main			; end of initialisation


; === auxiliary includes ===

.include 	"monitor_lib.asm"	; include Monitor module


; === main code ===

main:
	; PUT YOUR MAIN CODE HERE	

	rjmp	main			; main loop


; === sub-routine includes ===

	; PUT SUB-ROUTINES HERE


; === lookup tables ===

	; PUT LOOKUP TABLES HERE

